/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: FileExplorerDlg.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    cifX File explorer dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2007-04-23  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file FileExplorerDlg.h
///   cifX File explorer dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"
#include "afxcmn.h"
#include <vector>
#include "cifxuser.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// cifX File Explorer dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CFileExplorerDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CFileExplorerDlg)

public:
	CFileExplorerDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CFileExplorerDlg();

  virtual void ThreadFunction(void);
  virtual void OnUpdateDevice(CCifXDeviceBase* pcDevice);

// Dialog Data
	enum { IDD = IDD_FILELISTING_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
  CComboBox m_cChannelCtrl;
  CListCtrl m_cFileListCtrl;

  std::vector<CIFX_DIRECTORYENTRY>  m_cvDirectory;

public:
  virtual BOOL OnInitDialog();
  void    UpdateFileList();
  void    AddFile(CIFX_DIRECTORYENTRY* ptDirEntry);
  afx_msg void OnBnClickedBtnRefresh();
  afx_msg void OnBnClickedBtnUpload();
  afx_msg void OnBnClickedBtnDelete();
  afx_msg void OnCbnSelchangeCbChannelselection();
};
